unit IWDBExtCtrlsWAP;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb, 
  {$ENDIF}
  {$IFDEF Linux}
    QControls,
    {$ELSE}
      {$IFNDEF VSNET}
      Controls,
      {$ENDIF}
  {$ENDIF}
  Classes, DB,
  IWControlWAP, IWExtCtrlsWAP,
  {IWCompTextWAP,} IWWapTag, IWWAPRenderContext, IWBaseInterfaces;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBImageWAP.bmp}
  TIWDBImageWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBImageWAP), 'TIWDBImageWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBImageWAP = class(TIWDynamicImageWAP)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataTable(const ADataTable: System.Data.DataTable);
    function GetDataTable: System.Data.DataTable;
    function ShouldSerializeDataTable: Boolean;
    {$ENDIF}
public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property DataTable: System.Data.DataTable read GetDataTable write SetDataTable;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
  end;


(*  TIWDBRadioGroupWAP = class(TIWCustomRadioGroupWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    FValues: TIWStringList;
    //
    procedure InitControl; override;
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    procedure SetValues(const AValue: TIWStringList);
    procedure SetValue(const AValue: string); override;
  public
    destructor Destroy; override;
    function RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;

    property DataSource: TDataSource read FDataSource write FDataSource;

    property Values: TIWStringList read FValues write SetValues;
    property Items;
  end;
 *)
implementation

uses
  {$IFDEF VSNET}
  IWNetJPeg,
  {$ELSE}
    {$IFDEF CLR}
      IWNetJPEG,
    {$ELSE}
      {$IFDEF Linux}IWJpeg,{$ELSE}JPeg,{$ENDIF}
    {$ENDIF}
  {$ENDIF}
  IWDBCommon, IWControl, SysUtils;

{ TIWDBImageWAP }

{$IFDEF VSNET}
procedure TIWDBImageWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBImageWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited;
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

procedure TIWDBImageWAP.InitControl; 
begin
  inherited;
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBImageWAP.SetDataTable(const ADataTable: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(DataTable);
end;

function TIWDBImageWAP.ShouldSerializeDataTable: Boolean;
begin
  result := Assigned(DataTable);
end;

function TIWDBImageWAP.GetDataTable: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBImageWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited;
end;

function TIWDBImageWAP.RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
  S: TMemoryStream;
  Ljpg: TJPEGImage;
  LHeader: array [0..1] of byte;
begin
  // Clear first in case the datafield is empty so we dont display the last image
  FPicture.Graphic := nil;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsBlob then begin
      S := TMemoryStream.Create;
      try
        TBlobField(LField).SaveToStream(S);
        // Find file type
        S.Position := 0;
        S.Read(LHeader, 2);
        S.Position := 0;
        if (LHeader[0] = $FF) and (LHeader[1] = $D8) then begin
          LJPg := TJPEGImage.Create;
          try
            LJpg.LoadFromStream(S);
            FPicture.Assign(LJPG);
          finally
            FreeAndNil(LJpg);
          end;
        end else begin
          FPicture.Assign(LField);
        end;
      finally
        FreeAndNil(S);
      end;
    end;
  end;
  Result := inherited RenderWAP(AContext);
end;

{ TIWDBRadioGroupWAP }
{
procedure InitControl; override;
begin
  inherited InitControl;
  FValues := TStringList.Create;
end;

destructor TIWDBRadioGroupWAP.Destroy;
begin
  FreeAndNil(FValues);
  inherited Destroy;
end;

procedure TIWDBRadioGroupWAP.Notification(AComponent: TComponent;
  AOperation: TOperation);
begin
  inherited Notification(AComponent, AOperation);
  if (AOperation = opRemove) and (AComponent = DataSource) then begin
    FDataSource := nil;
  end;
end;

function TIWDBRadioGroupWAP.RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(DataSource, DataField, LField) then begin
     FItemIndex := FValues.IndexOf(GetFieldText(LField));
     if FItemIndex<0 then
        FItemIndex := FItems.IndexOf(GetFieldText(LField));
  end else begin
    FItemIndex := -1;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBRadioGroupWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(DataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with FItems do begin
        if FValues.Count > FItemIndex then begin
          s := FValues[FItemIndex]
        end else begin
          s := FItems[FItemIndex]
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      DataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

procedure TIWDBRadioGroupWAP.SetValues(const AValue: TIWStringList);
begin
  FValues.Assign(AValue);
end;
 }
end.
